%% -------------------------------------------------------------------------

% This script illustrates the use of the Autogram code "Autogram.m" 
% on a CWRU bearing signal.

% -------------------------------------------------------------------------

% Reference: “The Autogram: an effective approach for selecting the optimal
% demodulation band in rolling element bearings diagnosis” 
% Authors: Moshrefzadeh A, Fasana A
% Journal: Mechanical Systems and Signal Processing

% -------------------------------------------------------------------------

global x
global fr
global Fs
global Br
global Dn
global fd
global fmax
global l
% global ratio

level = 4;     % Maximum level of decomposition
lmp = 0;       % [Autogram;  Upper_Autogram;  Lower_Autogram] = [0; 1; -1]


%%% Spectra after Upper and Lower threshold 
% =========================
UL = 0;       % [Yes; No] = [1; 0]

%%% Increase the effect of upper threshold
% =========================
UP = 1.5;     % Defult value = 1

% Corrupted signal
% =========================
CUR = 0;      % is the signal corrupted: [Yes; No] = [1; 0]

%%% Screen rsolution  
% =========================
Res = 1;     % If the screen rsolution is not enough to show the CSES
             % correctly please increase the 'Res' value
             % Defult value = 1
         
%%% For signals belong to the CWRU data sets
% =========================


%if Spe ~= 0
%speedr = [1797 1772 1750 1730];

% Ratios of damage frequencies to shaft speed
ratio = [5.415 3.585 0.3983 2.357; 4.947 3.053 0.3816 1.994];
% ratio = [6.111 3.889 0.389 4.2780; 9.185 6.815 0.426 6.6020];
%fr = speedr(Spe)/60;
if Br == 1
    j = 1;
else
    j = 2;
end
fd = fr * ratio(j, Dn);
fs=zeros(size(fr));
fside1=zeros(size(fr));
fside2=zeros(size(fr));
fside3=zeros(size(fr));
fside4=zeros(size(fr));
for k=1:length(Dn)
    if Dn(k) == 1
        fs(k) = fr;
    elseif Dn(k) == 4
        fs(k) = ratio(j,3)*fr;
    else
        fs(k) = 0;
    end
    fside1(k) = fd(k) + fs(k);
    fside2(k) = fd(k) - fs(k);
    fside3(k) = 2*fd(k) + fs(k);
    fside4(k) = 2*fd(k) - fs(k);
end

%%
%%% =========================
% Fast_Autogram
%%% =========================
tic
c = Fast_Autogram(x,level,Fs);
toc

load filename S f fr_newFA

if Br == 1
    j = 1;
else
    j = 2;
end
fd = fr_newFA * ratio(j, Dn);
fs=zeros(size(fr_newFA));
fside1=zeros(size(fr_newFA));
fside2=zeros(size(fr_newFA));
fside3=zeros(size(fr_newFA));
fside4=zeros(size(fr_newFA));
for k=1:length(Dn)
    if Dn(k) == 1
        fs(k) = fr_newFA;
    elseif Dn(k) == 4
        fs(k) = ratio(j,3)*fr_newFA;
    else
        fs(k) = 0;
    end
    fside1(k) = fd(k) + fs(k);
    fside2(k) = fd(k) - fs(k);
    fside3(k) = 2*fd(k) + fs(k);
    fside4(k) = 2*fd(k) - fs(k);
end

width=1;
hold on;
plot([fr_newFA fr_newFA], [0 1.2],'-.','color',[1 0 1],'LineWidth',width); % magenta
plot([2*fr_newFA 2*fr_newFA], [0 1.2],'-.','color',[1 0 1],'LineWidth',width); % magenta
plot([3*fr_newFA 3*fr_newFA], [0 1.2],'-.','color',[1 0 1],'LineWidth',width); % magenta
hold on
for k=1:4
    if k==1
        color=[1 0 0]; % red
    elseif k==2
        color=[0 1 0]; % green
    elseif k==3
        color=[0 0 1]; % blue
    elseif k==4
        color=[0 0 0]; % black        
    end
    plot([fd(k) fd(k)], [0 1.2],'--','color',color,'LineWidth',width);
    plot(2*[fd(k) fd(k)], [0 1.2],'--','color',color,'LineWidth',width);
    plot([fside1(k) fside1(k)], [0 1.2],':','color',color,'LineWidth',width)
    plot([fside2(k) fside2(k)], [0 1.2],':','color',color,'LineWidth',width)
    plot([fside3(k) fside3(k)], [0 1.2],':','color',color,'LineWidth',width)
    plot([fside4(k) fside4(k)], [0 1.2],':','color',color,'LineWidth',width)
    xlim([0 fmax])
end
title('FAST AUTOGRAM shaft magenta, Inner red, Outer green, Cage blue, Ball black')
xlabel('Frequency (Hz)'),ylabel('Amplitude');
grid on, zoom on
%%

%%%% Finding damage 

fd_new2 = 0;
fd_new3 = 0;
fd_new4 = 0;
fd_new5 = 0;
fd_new6 = 0;
NNN=10;
PPP=10;
deltaf = f(2) - f(1);
percent = 0.03;
Error_2 = 0;
Error_3 = 0;
Error_4 = 0;
Error_5 = 0;
Error_6 = 0;

for i = 1:length(l)
    harmonics = l(i);  % Harmonic_column

    [ijk optimum] = min(abs(f-fd(harmonics)));        %1st harmonic
    Optimummin=optimum-ceil(NNN/2);
    Optimummax=optimum+ceil(PPP/2);
    [ijk optimum] = max(S(Optimummin:Optimummax)); 
    optimum=optimum+Optimummin-1; 
    fd_new1(i) = S(optimum);

    fd(harmonics)=f(optimum);
    fup = (1+percent)*fd(harmonics);
    fdown = (1-percent)*fd(harmonics);
    indices = find(fdown <= f & f <= fup);
    abc=S; % temporary variable
    abc(optimum-1:optimum+1)=0;
    bca=abc(indices);
    clear abc
    mu = mean(bca);
    Error_1(i) = (fd_new1(i) - mu)/fd_new1(i);     %Error at 1st harmonic

if 2*fd(l(i))+NNN*deltaf<fmax && 2*fd(l(i))<f(end)
    [ijk, optimum] = min(abs(f-2*fd(harmonics))); % 2nd harmonic
    Optimummin = optimum-ceil(NNN/2);
    Optimummax = optimum+ceil(PPP/2);
    [ijk, optimum] = max(S(Optimummin:Optimummax)); 
    optimum = optimum + Optimummin - 1; 
    fd_new2(i) = S(optimum);

    fd(harmonics)=f(optimum);
    fup = (1+percent)*fd(harmonics);
    fdown = (1-percent)*fd(harmonics);
    indices = find(fdown <= f & f <= fup);
    abc=S; % temporary variable
    abc(optimum-1:optimum+1)=0;
    bca=abc(indices);
    clear abc
    mu = mean(bca);
    Error_2(i) = (fd_new2(i) - mu)/fd_new2(i);     %Error at 2nd harmonic
end
end

if any(l==1) || any(l==4)   %setting outer_race & cage sidebands to 0

if fside1(l(i))+NNN*deltaf<fmax && fside1(l(i))<f(end)
    [ijk optimum] = min(abs(f-fside1(harmonics)));       %1st sideband
    Optimummin=optimum-ceil(NNN/2);
    Optimummax=optimum+ceil(PPP/2);
    [ijk optimum] = max(S(Optimummin:Optimummax)); 
    optimum=optimum+Optimummin-1; 
    fd_new3(i) = S(optimum);

    fside1(harmonics)=f(optimum);
    fup = (1+percent)*fside1(harmonics);
    fdown = (1-percent)*fside1(harmonics);
    indices = find(fdown <= f & f <= fup);
    abc=S; % temporary variable
    abc(optimum-1:optimum+1)=0;
    bca=abc(indices);
    clear abc
    mu = mean(bca);
    Error_3 = (fd_new3(i) - mu)/fd_new3(i);     %Error at 1st sideband
end

if fside2(l(i))+NNN*deltaf<fmax && fside2(l(i))<f(end)
    [ijk optimum] = min(abs(f-fside2(harmonics)));    %2nd sideband
    Optimummin=optimum-ceil(NNN/2);
    Optimummax=optimum+ceil(PPP/2);
    [ijk optimum] = max(S(Optimummin:Optimummax)); 
    optimum=optimum+Optimummin-1; 
    fd_new4(i) = S(optimum);

    fside2(harmonics)=f(optimum);
    fup = (1+percent)*fside2(harmonics);
    fdown = (1-percent)*fside2(harmonics);
    indices = find(fdown <= f & f <= fup);
    abc=S; % temporary variable
    abc(optimum-1:optimum+1)=0;
    bca=abc(indices);
    clear abc
    mu = mean(bca);
    Error_4 = (fd_new4(i) - mu)/fd_new4(i);     %Error at 2nd sideband
end

if fside3(l(i))+NNN*deltaf<fmax && fside3(l(i))<f(end)
    [ijk optimum] = min(abs(f-fside3(harmonics)));    %3rd sideband
    Optimummin=optimum-ceil(NNN/2);
    Optimummax=optimum+ceil(PPP/2);
    [ijk optimum] = max(S(Optimummin:Optimummax)); 
    optimum=optimum+Optimummin-1; 
    fd_new5(i) = S(optimum);

    fside3(harmonics)=f(optimum);
    fup = (1+percent)*fside3(harmonics);
    fdown = (1-percent)*fside3(harmonics);
    indices = find(fdown <= f & f <= fup);
    abc=S; % temporary variable
    abc(optimum-1:optimum+1)=0;
    bca=abc(indices);
    clear abc
    mu = mean(bca);
    Error_5 = (fd_new5(i) - mu)/fd_new5(i);     %Error at 3rd sideband
end

if fside4(l(i))+NNN*deltaf<fmax && fside4(l(i))<f(end)
    [ijk optimum] = min(abs(f-fside4(harmonics)));    %4th sideband
    Optimummin=optimum-ceil(NNN/2);
    Optimummax=optimum+ceil(PPP/2);
    [ijk optimum] = max(S(Optimummin:Optimummax)); 
    optimum=optimum+Optimummin-1; 
    fd_new6(i) = S(optimum);

    fside4(harmonics)=f(optimum);
    fup = (1+percent)*fside4(harmonics);
    fdown = (1-percent)*fside4(harmonics);
    indices = find(fdown <= f & f <= fup);
    abc=S; % temporary variable
    abc(optimum-1:optimum+1)=0;
    bca=abc(indices);
    clear abc
    mu = mean(bca);
    Error_6 = (fd_new6(i) - mu)/fd_new6(i);     %Error at 4th sideband
end

end % if l==1 || l==4

Total_damage_1 = 0;
Total_damage_2 = 0;
Total_damage_3 = 0;
Total_damage_4 = 0;
Error_FastAutogram_1 = 0;
Error_FastAutogram_2 = 0;
Error_FastAutogram_3 = 0;
Error_FastAutogram_4 = 0;

for i = 1:length(l)
    damage = l(i);

if damage == 1  %Inner_race 
   Total_damage_1 = fd_new1(i)+fd_new2(i)+fd_new3(i)+fd_new4(i)+fd_new5(i)+fd_new6(i);  
   Error_FastAutogram_1 = (Error_1+Error_2+Error_3+Error_4+Error_5+Error_6)/6;  %Indication of total error for harmonics with its sidebands  
end
if damage == 2  %Outer_race 
   Total_damage_2 = fd_new1(i)+fd_new2(i);
   Error_FastAutogram_2 = (Error_1(i)+Error_2(i))/2;  %Indication of total error for harmonics
end

if damage == 3  %Cage
   Total_damage_3 = fd_new1(i)+fd_new2(i);
   Error_FastAutogram_3 = (Error_1(i)+Error_2(i))/2;  %Indication of total error for harmonics
end

if damage == 4  %Ball
   Total_damage_4 = fd_new1(i)+fd_new2(i)+fd_new3(i)+fd_new4(i)+fd_new5(i)+fd_new6(i);
   Error_FastAutogram_4 = (Error_1(i)+Error_2(i)+Error_3+Error_4+Error_5+Error_6)/6;  %Indication of total error for harmonics with its sidebands  
end
end

if any(l==1)
    Error_FastAutogram = Error_FastAutogram_1;
end 
if any(l==2)
    Error_FastAutogram = Error_FastAutogram_2;
end 
if (l==4)
    Error_FastAutogram = Error_FastAutogram_4;
end 
if any(l==3) && any(l==4)
    Error_FastAutogram = (Error_FastAutogram_3+Error_FastAutogram_4)/2;
end 

Total_damage = Total_damage_1+Total_damage_2+Total_damage_3+Total_damage_4;         %Total damage

filter_values = [fd_new1,fd_new2,fd_new3,fd_new4,fd_new5,fd_new6];  %filter_values of max. peak values from the spectrum
indices_to_filter = ismember(S, filter_values);
S_New = S(~indices_to_filter);  %To get new spectrum   

damage_FastAutogram = Total_damage/rms(S_New);      %damage
tmp=sort(S_New,'descend');
MMM=50;
damage_FastAutogram_tmp = Total_damage/rms(tmp(1:MMM));     %damage

median_value = rms(S_New);    
width = 1;
yline(median_value, 'r-','LineWidth',width) %plot the new median value of the RMS of the spectrum